<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LibraryStorageFile extends Model 
{

    protected $table = 'library_storage_file';
    public $timestamps = true;
    protected $guarded = array('md5');
    protected $fillable = array('original_id', 'library_storage_file_variant_id', 'library_storage_id', 'name', 'ext', 'size', 'mime', 'usage', 'status');

    public function libraryFiles()
    {
        return $this->hasMany('App\Models\LibraryFile');
    }

    public function originalLibraryStorageFile()
    {
        return $this->belongsTo('App\Models\LibraryStorageFile', 'original_id');
    }

    public function libraryStorageFileVariant()
    {
        return $this->belongsTo('App\Models\LibraryStorageFileVariant');
    }

    public function libraryStorage()
    {
        return $this->belongsTo('App\Models\LibraryStorage');
    }

    public function libraryStorageFileMetas()
    {
        return $this->hasMany('App\Models\LibraryStorageFileMeta');
    }

    public function albumart()
    {
        return $this->belongsTo('App\Models\Albumart');
    }

}